// @name "Search (04.09.2013)"
// @author "NADIR1"

var clear_off = gdi.CreateImage(24, 24);
var gb = clear_off.GetGraphics();
gb.SetSmoothingMode(2);
gb.DrawLine(5, 5, 16, 16, 2, blendColors(g_textcolor, g_backcolor, 0.4));
gb.DrawLine(5, 16, 16, 5, 2, blendColors(g_textcolor, g_backcolor, 0.4));
clear_off.ReleaseGraphics(gb);

var clear_ov = gdi.CreateImage(24, 24);
gb = clear_ov.GetGraphics();
gb.SetSmoothingMode(2);
gb.DrawLine(5, 5, 16, 16, 2, g_textcolor);
gb.DrawLine(5, 16, 16, 5, 2, g_textcolor);
clear_ov.ReleaseGraphics(gb);

var clear_on = gdi.CreateImage(24, 24);
gb = clear_on.GetGraphics();
gb.SetSmoothingMode(2);
gb.DrawLine(5, 5, 16, 16, 2, blendColors(g_textcolor, g_backcolor, 0.6));
gb.DrawLine(5, 16, 16, 5, 2, blendColors(g_textcolor, g_backcolor, 0.6));
clear_on.ReleaseGraphics(gb);

var px = 0;
var py = 0;
var pw = 0;
var ph = 0;

var ommRepaint = false;
var omldRepaint = false;
var omluRepaint = false;
var omrdRepaint = false;
var omruRepaint = false;
var omwRepaint = false;
var okdRepaint = false;
var ocRepaint = false;
var ofRepaint = false;

window.DlgCode = DLGC_WANTALLKEYS | DLGC_WANTCHARS;

var tooltip = window.CreateTooltip();
var search_timerID = false;

var temp_bmp = gdi.CreateImage(1, 1);
var temp_gr = temp_bmp.GetGraphics();

function FormSimpleInput() {

	this.clear = {
		bt : null,
		clear_off : null,
		clear_ov : null,
		clear_on : null
	}

	this.search = {
		bt : null,
		search_off : null,
		search_ov : null,
		search_on : null
	}

	this.Open = function (str, x, y, w, font) {
		this.active = true;

		this.default_text = "";
		this.edit = false;

		this.Text = str;
		this.SText = str;
		this.rx = x;
		this.x = Math.max(0, eval(x));
		this.ry = y;
		this.y = Math.max(0, eval(y));
		this.rw = w;
		this.w = Math.max(0, eval(w));
		this.Font = font;

		var arr = temp_gr.GdiDrawText(".", this.Font, 0, 0, 0, 9999999, 9999999, DT_VCENTER | DT_CALCRECT).toArray();
		this.THeight = arr[3] - arr[1];
		this.CPos = 0;
		this.select = false;
		this.Offset = 0;
		this.CalcText();

		search_ico = gdi.CreateImage(24, 18);
		gb = search_ico.GetGraphics();
		gb.SetSmoothingMode(2);
		gb.DrawEllipse(13, 4.5, 8.1, 8.1, 1.6, g_backcolor);
		gb.DrawLine(10, 16, 14, 12, 1.8, g_backcolor);
		search_ico.ReleaseGraphics(gb);

		search_off = gdi.CreateImage(this.THeight * 2 + 2 * marginy, this.THeight + 2 * marginy);
		gb = search_off.GetGraphics();
		gb.FillSolidRect(0, 0, this.THeight * 2 + 2 * marginy, this.THeight + 2 * marginy, blendColors(g_textcolor, g_backcolor, 0.6));
		mid_x = Math.round(search_off.Width / 2);
		mid_y = Math.round(search_off.Height / 2);
		gb.DrawImage(search_ico, mid_x - 16, mid_y - 11, search_ico.Width, search_ico.Height, 0, 0, search_ico.Width, search_ico.Height);
		search_off.ReleaseGraphics(gb);

		search_ov = gdi.CreateImage(this.THeight * 2 + 2 * marginy, this.THeight + 2 * marginy);
		gb = search_ov.GetGraphics();
		gb.FillSolidRect(0, 0, this.THeight * 2 + 2 * marginy, this.THeight + 2 * marginy, blendColors(g_textcolor, g_backcolor, 0.4));
		mid_x = Math.round(search_off.Width / 2);
		mid_y = Math.round(search_off.Height / 2);
		gb.DrawImage(search_ico, mid_x - 16, mid_y - 11, search_ico.Width, search_ico.Height, 0, 0, search_ico.Width, search_ico.Height);
		search_ov.ReleaseGraphics(gb);

		search_on = gdi.CreateImage(this.THeight * 2 + 2 * marginy, this.THeight + 2 * marginy);
		gb = search_on.GetGraphics();
		gb.FillSolidRect(0, 0, this.THeight * 2 + 2 * marginy, this.THeight + 2 * marginy, blendColors(g_textcolor, g_backcolor, 0.8));
		mid_x = Math.round(search_off.Width / 2);
		mid_y = Math.round(search_off.Height / 2);
		gb.DrawImage(search_ico, mid_x - 16, mid_y - 11, search_ico.Width, search_ico.Height, 0, 0, search_ico.Width, search_ico.Height);
		search_on.ReleaseGraphics(gb);

		this.clear.bt = new button(clear_off, clear_ov, clear_on);
		this.search.bt = new button(search_off, search_ov, search_on);

		window.Repaint();
	}

	//--------------------
	// function SimpleInput.Close()
	//--------------------
	// Closes the text input line

	this.Close = function () {
		if (this.active) {
			this.active = false;
			if (this.Text != this.SText)
				if (this.func) {
					this.func(this.Text);
					myinputbox.Reload();
				}
		}
	}

	this.rx = 0;
	this.x = 0;
	this.ry = 0;
	this.y = 0;
	this.rw = 0;
	this.w = 0;
	this.Text = "";
	this.SText = "";
	this.Font = null;
	this.func = null;
	this.rbfunc = null;
	this.Offset = 0;
	this.TLength = null;
	this.TWidth = null;
	this.THeight = null;
	this.CPos = 0;
	this.SPos = 0;
	this.Cx = 0;
	this.THeight = 0;
	this.insert = false;
	this.select = false;

	this.cvisible = true;
	this.crpx = 0;
	this.crpy = 0;
	this.crpw = 0;
	this.crph = 0;
	this.CopyBuffer = "";

	this.lbtnd = false;
	this.AutoPlaylist = window.GetProperty("Search.AutoPlaylists", true);
	this.TagSearch = window.GetProperty("Search.Tag", 0);

	this.resize = function () {
		this.x = Math.max(0, eval(this.rx));
		this.y = Math.max(0, eval(this.ry));
		this.w = Math.max(0, eval(this.rw));
	}

	this.Repaint = function () {
		window.RepaintRect(this.x - marginx, this.y - marginy, this.w + 2 * marginx + 50, this.THeight + 2 * marginy);
	}

	this.draw = function (gr) {
		if (this.active) {

			gr.FillSolidRect(this.x - marginx, this.y - marginy, this.w + 2 * marginx + 44, this.THeight + 2 * marginy, editbackcolour);

			if (this.edit) {
				gr.FillSolidRect(this.x - marginx, this.y - marginy, 1, this.THeight + 2 * marginy, RGBA(0, 0, 0, 25));
				gr.FillSolidRect(this.x - marginx + 1, this.y - marginy, 1, this.THeight + 2 * marginy, RGBA(0, 0, 0, 10));
				gr.FillSolidRect(this.x - marginx, this.y - marginy, this.w + 2 * marginx + 44, 1, RGBA(0, 0, 0, 25));
				gr.FillSolidRect(this.x - marginx, this.y - marginy + 1, this.w + 2 * marginx + 44, 1, RGBA(0, 0, 0, 10));
			}

			if (this.select)
				this.DrawSelection(gr);

			this.ForceVisible();

			gr.GdiDrawText(this.Text.substr(this.Offset), this.Font, this.edit ? edittextcolour : normaltextcolour, this.x, this.y, this.w, this.THeight, DT = DT_LEFT | DT_SINGLELINE | DT_NOPREFIX | DT_CALCRECT);

			if (this.edit)
				this.DrawCursor(gr);

			if (this.Text != this.default_text && this.Text.length > 0) {
				this.clear.bt.draw(gr, this.x + this.w + marginy + 2, this.y - marginy + 5, 255);
			}

			this.search.bt.draw(gr, this.x + this.w + 36, this.y - marginy, 255);

		}
	}

	this.on_mousemove = function (x, y) {
		if (this.active) {
			var hov = (this.x < x && x < (this.x + this.w) && this.y < y && y < (this.y + this.THeight)) ? true : false;
			if (hov != this.hover) {
				if (hov) {
					if (this.w < this.TWidth) {
						tooltip.Text = this.Text;
						tooltip.Activate();
					}
				} else
					tooltip.Deactivate();
				window.SetCursor(hov ? IDC_IBEAM : IDC_ARROW);
				this.hover = hov;
				this.Repaint();
			}
			if (this.lbtnd) {
				var tmp = this.CPos;
				this.GetCPos(x);
				if (this.Cpos != this.SPos)
					this.select = true;
				if (tmp != this.CPos)
					ommRepaint = true;
				this.Repaint();
			}
		}

		this.clear.bt.checkstate("move", x, y);
		this.search.bt.checkstate("move", x, y);
	}

	this.on_mouse_lbtn_down = function (x, y) {
		if (this.hover) {
			if (this.Text == this.default_text) {
				this.Text = ""
			}
			this.edit = true;
			this.select = false;
			this.GetCPos(x);
			this.SPos = this.CPos;
			omldRepaint = true;

			this.lbtnd = true;
			this.Repaint();
		} else {
			if (this.edit) {
				if (this.Text.length == 0) {
					this.Text = this.default_text;
				}
				this.edit = false;
				this.select = false;
				this.Repaint();
				omldRepaint = true;
			}

		}

		this.clear.bt.checkstate("down", x, y);
		this.search.bt.checkstate("down", x, y);
	}

	this.on_mouse_lbtn_up = function (x, y) {
		this.lbtnd = false;

		if (this.clear.bt.checkstate("up", x, y) == ButtonStates.hover) {
			this.Text = "";
			this.edit = true;
			this.select = false;
			this.GetCPos(x);
			this.SPos = this.CPos;
			this.Repaint();
			this.clear.bt.state = ButtonStates.hover;
		}
		if (this.search.bt.checkstate("up", x, y) == ButtonStates.hover) {
			this.func(this.Text);
			this.search.bt.state = ButtonStates.hover;
		}
		return true;
	}

	this.on_mouse_rbtn_up = function (x, y) {

		if (this.hover) {
			var _menu = window.CreatePopupMenu();
			var _tag = window.CreatePopupMenu();

			var idx;

			if (!safeMode) {
				paste_cbd = doc.parentWindow.clipboardData.getData("Text");

				_menu.AppendMenuItem(this.SelBegin != this.SelEnd ? MF_STRING : MF_GRAYED, 1, "");
				_menu.AppendMenuItem(this.SelBegin != this.SelEnd ? MF_STRING : MF_GRAYED, 2, "");
				_menu.AppendMenuItem(paste_cbd ? MF_STRING : MF_GRAYED, 3, "ճ");
				_menu.AppendMenuItem(this.SelBegin != this.SelEnd ? MF_STRING : MF_GRAYED, 4, "ɾ");
				_menu.AppendMenuItem(MF_SEPARATOR, 0, "");
				_menu.AppendMenuItem((this.select != this.Text) && this.Text ? MF_STRING : MF_GRAYED, 5, "ȫѡ");

			}

			idx = _menu.TrackPopupMenu(x, y);
			switch (idx) {
			case 1:
				doc.parentWindow.clipboardData.setData("Text", this.Text.substr(this.SelBegin, this.SelEnd - this.SelBegin));
				this.Text = this.Text.slice(0, this.SelBegin) + this.Text.slice(this.SelEnd);
				this.CPos = this.SelBegin;
				this.select = false;
				this.CalcText();
				this.CalcOText();
				ocRepaint = true;
				break;
			case 2:
				doc.parentWindow.clipboardData.setData("Text", this.Text.substr(this.SelBegin, this.SelEnd - this.SelBegin));
				break;
			case 3:
				if (doc.parentWindow.clipboardData.getData("Text").length > 0) {
					if (this.select) {
						var p1 = this.SelBegin;
						var p2 = this.SelEnd;
						this.CPos = this.SelBegin;
						this.select = false;
					} else {
						var p1 = this.CPos;
						var p2 = this.CPos;
						if (this.insert)
							p2 += doc.parentWindow.clipboardData.getData("Text").length;
						if (p2 > this.Text.length - 1)
							p2 = this.Text.length - 1;
					}
					this.Text = this.Text.slice(0, p1) + doc.parentWindow.clipboardData.getData("Text") + this.Text.slice(p2);
					this.CPos += doc.parentWindow.clipboardData.getData("Text").length;
					this.select = false;
					this.CalcText();
					this.CalcOText();
					ocRepaint = true;
				}
				break;
			case 4:
				if (this.select) {
					this.Text = this.Text.slice(0, this.SelBegin) + this.Text.slice(this.SelEnd);
					this.CPos = this.SelBegin;
					this.select = false;
					this.SelBegin = this.SelEnd;
					this.CalcText();
				} else {
					this.select = false;
					this.SelBegin = this.SelEnd;
				}
				break;
			case 5:
				this.SPos = 0;
				this.CPos = this.Text.length;
				this.select = true;
				ocRepaint = true;
				break;

			}
			_menu.Dispose();
			_tag.Dispose();

			return true;
		}

	}

	this.Reload = function () {
		//SimpleInput.reload = true;
		//for (var i in this.list) this.list[i].reload = true;
		//for (var i in this.popuplist) this.popuplist[i].reload = true;
		this.Repaint();
	}

	this.on_key = function (vkey, mask) {
		if (this.active) {
			if (mask == KMask.none) {
				switch (vkey) {
				case VK_BACK:
					if (this.edit) {
						if (this.select) {
							this.Text = this.Text.slice(0, this.SelBegin) + this.Text.slice(this.SelEnd);
							this.CPos = this.SelBegin;
							this.select = false;
							this.CalcText();
						} else {
							if (this.CPos > 0) {
								this.Text = this.Text.slice(0, this.CPos - 1) + this.Text.slice(this.CPos);
								this.CPos--;
								this.CalcText();
							}
						}
					}
					break;
				case VK_RETURN:
					if (this.edit) {
						this.edit = false;
						//if (this.Text != this.SText)
						if (this.func) {
							this.func(this.Text);
							myinputbox.Reload();
						}
					} else {
						this.select = false;
						this.CPos = this.TLength
					}
					//this.Close();
					break;
				case VK_ESCAPE:
					if (this.edit) {
						this.edit = false;
						this.Text = "";
					}
					//this.Close();
					break;
				case VK_END:
					if (this.edit) {
						this.CPos = this.TLength;
						this.select = false;
					}
					break;
				case VK_HOME:
					if (this.edit) {
						this.CPos = 0;
						this.Offset = 0;
						this.select = false;
					}
					break;
				case VK_LEFT:
					if (this.edit) {
						if (this.select) {
							this.CPos = this.SelBegin;
							this.select = false;
						} else if (this.CPos > 0)
							this.CPos--;
					}
					break;
				case VK_RIGHT:
					if (this.edit) {
						if (this.select) {
							this.CPos = this.SelEnd;
							this.select = false;
						} else if (this.CPos < this.TLength)
							this.CPos++;
					}
					break;
				case VK_INSERT:
					if (this.edit) {
						this.insert = !this.insert;
					}
					break;
				case VK_DELETE:
					if (this.edit) {
						if (this.select) {
							this.Text = this.Text.slice(0, this.SelBegin) + this.Text.slice(this.SelEnd);
							this.CPos = this.SelBegin;
							this.select = false;
							this.CalcText();
						} else {
							this.Text = this.Text.slice(0, this.CPos) + this.Text.slice(this.CPos + 1);
							this.CalcText();
						}
					}
					break;
				}
				this.Repaint();
			}
			if (mask == KMask.shift) {
				switch (vkey) {
				case VK_END:
					if (this.edit) {
						if (!this.select) {
							this.SPos = this.CPos;
							this.select = true;
						}
						this.CPos = this.TLength;
					}
					break;
				case VK_HOME:
					if (this.edit) {
						if (!this.select) {
							this.SPos = this.CPos;
							this.select = true;
						}
						this.CPos = 0;
						this.Offset = 0;
					}
					break;
				case VK_LEFT:
					if (this.edit) {
						if (!this.select) {
							this.SPos = this.CPos;
							this.select = true;
						}
						if (this.CPos > 0)
							this.CPos--;
					}
					break;
				case VK_RIGHT:
					if (this.edit) {
						if (!this.select) {
							this.SPos = this.CPos;
							this.select = true;
						}
						if (this.CPos < this.TLength)
							this.CPos++;
					}
					break;
				}
				if (this.edit)
					this.Repaint();
			}
		}
	}

	this.on_char = function (code, mask) {
		if (this.active) {
			if (code == 1 && this.edit && mask == KMask.ctrl) {
				// ctrl a
				this.SPos = 0;
				this.CPos = this.Text.length;
				this.select = true;
				this.Repaint();
			}
			if (code == 3 && this.edit && this.select && mask == KMask.ctrl) {
				// ctrl c
				myinputbox.CopyBuffer = this.Text.substr(this.SelBegin, this.SelEnd - this.SelBegin);
			}
			if (code == 22 && this.edit && mask == KMask.ctrl) {
				// ctrl v
				if (myinputbox.CopyBuffer.length > 0) {
					if (this.select) {
						var p1 = this.SelBegin;
						var p2 = this.SelEnd;
						this.CPos = this.SelBegin;
						this.select = false;
					} else {
						var p1 = this.CPos;
						var p2 = this.CPos;
						if (this.insert)
							p2 += myinputbox.CopyBuffer.length;
						if (p2 > this.Text.length - 1)
							p2 = this.Text.length - 1;
					}
					this.Text = this.Text.slice(0, p1) + myinputbox.CopyBuffer + this.Text.slice(p2);
					this.CPos += myinputbox.CopyBuffer.length;
					this.select = false;
					this.CalcText();
					this.CalcOText();
					this.Repaint();
				}
			}
			if (code == 24 && this.edit && this.select && mask == KMask.ctrl) {
				// ctrl x
				myinputbox.CopyBuffer = this.Text.substr(this.SelBegin, this.SelEnd - this.SelBegin);
				this.Text = this.Text.slice(0, this.SelBegin) + this.Text.slice(this.SelEnd);
				this.CPos = this.SelBegin;
				this.select = false;
				this.CalcText();
				this.CalcOText();
				this.Repaint();
			}
			if (code == 9) {
				// tab

				//this.Close();
			}
			if (code == 26 && this.edit) {
				// ctrl z
				this.Text = this.SText;
				this.CPos = this.TLength;
				this.select = false;
				this.CalcText();
				this.Repaint();
			}
			if (code > 31 && this.edit) {
				if (this.select) {
					var p1 = this.SelBegin;
					var p2 = this.SelEnd;
					this.CPos = this.SelBegin;
					this.select = false;
				} else {
					var p1 = this.CPos;
					var p2 = this.CPos;
					if (this.insert)
						p2++;
				}
				this.Text = this.Text.slice(0, p1) + String.fromCharCode(code) + this.Text.slice(p2);
				this.CPos++;
				this.CalcText();
				this.Repaint();
			}
		}
	}

	this.on_focus = function (is_focused) {
		this.edit = is_focused;
		if (is_focused)
			this.Text = this.default_text;
		this.Repaint();
	}

	this.CalcText = function () {
		var arr = temp_gr.GdiDrawText(this.Text, this.Font, 0, 0, 0, 9999999, 9999999, DT_NOPREFIX | DT_CALCRECT).toArray();
		this.TLength = arr[4];
		this.TWidth = temp_gr.CalcTextWidth(this.Text, this.Font);
	}

	this.CalcOText = function () {
		if (this.Offset > 0) {
			var arr = temp_gr.GdiDrawText(this.Text, this.Font, 0, 0, 0, this.w, this.Offset * this.THeight, DT_WORDBREAK | DT_NOPREFIX | DT_EDITCONTROL | DT_CALCRECT).toArray();
			this.OBegin = arr[4];
		} else
			this.OBegin = 0;
	}

	this.DrawSelection = function (gr) {
		var tmp = this.CPos > this.SPos;
		this.SelBegin = tmp ? this.SPos : this.CPos;
		this.SelEnd = tmp ? this.CPos : this.SPos;
		if (this.SelBegin < this.Offset)
			this.SelBegin = this.Offset;
		if (this.SelBegin != this.SelEnd) {
			var Sx1 = temp_gr.CalcTextWidth(this.Text.substr(this.Offset, this.SelBegin - this.Offset), this.Font);
			var Sx2 = temp_gr.CalcTextWidth(this.Text.substr(this.Offset, this.SelEnd - this.Offset), this.Font);

			//gr.SetSmoothingMode(2);
			gr.FillSolidRect(this.x + Sx1, this.y - 3, (this.w < (Sx2 - Sx1) ? this.w : Sx2 - Sx1 + 1), this.THeight + 6, selectcolour);
			//gr.SetSmoothingMode(2);
		}
	}

	this.DrawCursor = function (gr) {
		if (this.insert) {
			var x1 = this.x + this.Cx;
			var x2 = this.x + this.Cx + Math.round(0.3 * this.THeight);
			var y1 = this.y + this.THeight;
			var y2 = this.y + this.THeight;
			var lt = 2;
			myinputbox.crpx = x1;
			myinputbox.crpy = y1 - 1;
			myinputbox.crpw = x2 - x1 + 1;
			myinputbox.crph = lt + 1;
		} else {
			var x1 = this.x + this.Cx;
			var x2 = this.x + this.Cx;
			var y1 = this.y;
			var y2 = this.y + this.THeight;
			var lt = 1;
			myinputbox.crpx = x1;
			myinputbox.crpy = y1;
			myinputbox.crpw = lt;
			myinputbox.crph = y2 - y1 + 1;
		}
		if (myinputbox.cvisible)
			gr.DrawLine(x1, y1, x2, y2, lt, edittextcolour);
	}

	this.ForceVisible = function () {
		while (this.CPos < this.Offset)
			this.Offset--;
		this.Cx = temp_gr.CalcTextWidth(this.Text.substr(this.Offset, this.CPos - this.Offset), this.Font);
		while (this.Cx > this.w) {
			this.Offset++;
			this.Cx = temp_gr.CalcTextWidth(this.Text.substr(this.Offset, this.CPos - this.Offset), this.Font);
		}
	}

	this.GetCPos = function (x) {
		x -= this.x
		this.CPos = this.Offset;
		var trlen = temp_gr.CalcTextWidth(this.Text.substr(this.Offset), this.Font);
		if (x > trlen)
			this.CPos = this.TLength;
		else {
			var arr = temp_gr.GdiDrawText(this.Text.substr(this.Offset), this.Font, 0, 0, 0, this.w, this.THeight, DT_WORDBREAK | DT_NOPREFIX | DT_EDITCONTROL | DT_CALCRECT).toArray();
			var tmp = x / trlen * arr[4];
			var td1 = x - temp_gr.CalcTextWidth(this.Text.substr(this.Offset, tmp), this.Font);
			var sign = td1 == 0 ? 1 : Math.abs(td1) / td1;
			var e = 0;
			do {
				tmp += sign;
				td2 = x - temp_gr.CalcTextWidth(this.Text.substr(this.Offset, tmp), this.Font);
				t = td1;
				td1 = td2;
				e++;
				if (e > 100) {
					fb.trace("ERROR SimpleInput.GetCPos");
					break
				}
			} while (Math.abs(td2) < Math.abs(t));
			this.CPos += Math.floor(tmp - sign);
		}
	}

	this.func = function (str) {
		var i;
		var last_id;
		var pl_name;
		var str_tag;
		var is_query = false;
		var found = -1;

		if (arguments.length == 0) {
			return myinputbox.Text;
		} else if (str.length > 0 || (str.length == 0)) {
			pl_name = " [" + str + "]";
			 + str;

			for (var i = 0; i < plman.PlaylistCount; i++) {
				if (plman.GetPlaylistName(i).substr(0, 4) == " [") {
					found = i;
				}
			}

			// Tags Used
			switch (this.TagSearch) {
			case 0:
				// Standard
				str_tag = "%artist% %album% %title% HAS " + str;
				break;
			case 1:
				// All fields
				str_tag = "" + str;
				break;
			case 2:
				// Artist
				str_tag = "%artist% HAS " + str;
				break;
			case 3:
				// Album
				str_tag = "%album% HAS " + str;
				break;
			case 4:
				// Album (Artist)
				str_tag = "%album artist% HAS " + str;
				break;
			case 5:
				// Title
				str_tag = "%title% HAS " + str;
				break;
			case 6:
				// Genre
				str_tag = "%genre% HAS " + str;
				break;
			case 7:
				// Year
				str_tag = "%date% HAS " + str;
				break;
			case 8:
				// Filename
				str_tag = "%_filename% HAS " + str;
				break;
			case 9:
				// Rating
				str_tag = "%rating% HAS " + str;
				break;
			case 10:
				// Directory
				str_tag = "%directoryname% HAS " + str;
				break;
			}

			if (found >= 0) {
				plman.RemovePlaylist(found);
			}
			last_id = plman.PlaylistCount;

			if (this.AutoPlaylist) {
				plman.CreateAutoPlaylist(last_id, pl_name, str_tag);
			} else {
				plman.CreateAutoPlaylist(last_id, "&tmp", str_tag);
				plman.DuplicatePlaylist(last_id, pl_name);
				plman.RemovePlaylist(last_id);
			}

			if (found >= 0) {
				plman.MovePlaylist(last_id, found);
				plman.ActivePlaylist = found;
			} else {
				plman.ActivePlaylist = last_id;
			}

		} else {
			myinputbox.Reset();
		}

	}
}
